---
title: How to receive a transaction to Feather
nav_title: Receive a transaction
category: getting-started
weight: 100
---

Go to the **Receive** tab.

If no addresses show up in the table, click on **Create New Address**.

It does not matter which address you choose, funds received to any of the addresses will end up in the same wallet account.

It is best practice to label an address before you copy it. This way you avoid accidentally reusing the address. You should label the address with the name of the person or service that will know about the address. Do not hand out addresses to more parties than necessary. For addresses that are shared publicly enter where it will be shared or the alias/pseudonym under which it will be shared.

Copy the address to your clipboard by right-clicking on an address **→ Copy Address** or by pressing `Ctrl + C`. **Never write down an address by hand**, a mistake may result in unrecoverable funds.

If you need to transfer the address to a different device, here are some options:

- Save your address to a .txt file and use a USB drive to transfer it
- Scan the QR code with a secondary device
- Send an e-mail containing the address to yourself

For increased readability, addresses are only shown partially. If you must copy an address manually, right click on the table header **→ Show full addresses**. 

Once an address receives an incoming transaction it is automatically hidden from view. You can unhide used addresses by clicking on **Show used**.

If you want to manually hide an address, right click on the address **→ Hide Address**. You can unhide hidden addresses by clicking on **Show hidden**.

### Q: A service tells me the address is invalid. What do I do?

Go to [https://xmr.llcoins.net/addresstests.html](https://xmr.llcoins.net/addresstests.html).

Paste the address in Box 8. Click on **Check Address**. Then, check the text next to Box 14.

If the address is **valid**, you should contact the service and notify them of the issue.

If the address is **invalid**, make sure you have copied the address correctly. Addresses should be 95 characters long. If the problem persist, please [report](report-an-issue) the issue to the Feather developers.

### Q: I'm expecting an incoming transaction, but it hasn't shown up yet.

Please view: [Help: missing transaction](missing-tx).
