/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#include "aboutui.h"
#include <QGridLayout>
#include <QSvgRenderer>
#include <QPluginLoader>
#include <QDebug>
#include <QDate>

AboutUi::AboutUi(QWidget *parent) : QWidget(parent)
{
    initCopyRightName();
    initUi();
    initSearchText();
    setComponent();
}

void AboutUi::initUi()
{
    QVBoxLayout *mverticalLayout = new QVBoxLayout(this);
    mverticalLayout->setSpacing(0);
    mverticalLayout->setContentsMargins(0, 0, 0, 0);

    QWidget *Aboutwidget = new QWidget(this);
    Aboutwidget->setMinimumSize(QSize(550, 0));
    Aboutwidget->setMaximumSize(QSize(16777215, 16777215));

    QVBoxLayout *AboutLayout = new QVBoxLayout(Aboutwidget);
    AboutLayout->setContentsMargins(0, 0, 0, 0);
    AboutLayout->setSpacing(8);

    mTitleLabel = new TitleLabel(Aboutwidget);
    mTitleLabel->setText(tr("System Summary"));
    mPriTitleLabel = new TitleLabel(Aboutwidget);
    mPriTitleLabel->setText(tr("Privacy and agreement"));
    mHoldTitleLabel = new TitleLabel(Aboutwidget);
    mHoldTitleLabel->setText(tr("Support"));

    mInformationFrame = new QFrame(Aboutwidget);
    setShape(mInformationFrame, QFrame::Box);

    QVBoxLayout *mInformationLayout = new QVBoxLayout(mInformationFrame);
    int space = UkccCommon::isTablet() ? 32 : 16;
    mInformationLayout->setContentsMargins(space, space, space, space);

    /* LOGO */
    mLogoLabel = new FixLabel(mInformationFrame);
    mLogoLabel->setFixedSize(130, 50);

     /* 版本名称 */
    mVersionLabel_1 = new FixLabel(tr("Version"));
    mVersionLabel_2 = new LightLabel;
    mVersionFrame = createFrame(mVersionLabel_1, mVersionLabel_2);

     /* 版本号 */
    mVersionNumberLabel_1 = new FixLabel(tr("Version Number"));
    mVersionNumberLabel_2 = new LightLabel;
    mVersionNumberFrame = createFrame(mVersionNumberLabel_1, mVersionNumberLabel_2);

    /* 系统补丁版本号 */
    mPatchVersionLabel_1 = new FixLabel(tr("Patch Version"));
    mPatchVersionLabel_2 = new LightLabel;
    mPatchVersionFrame = createFrame(mPatchVersionLabel_1, mPatchVersionLabel_2);

    /* 安装日期 */
    mInstallDateLabel_1 = new FixLabel(tr("Installed Date"));
    mInstallDateLabel_2 = new LightLabel;
    mInstallDateFrame = createFrame(mInstallDateLabel_1, mInstallDateLabel_2);

    /* 系统更新时间 */
    mUpgradeDateLabel_1 = new FixLabel(tr("Upgrade Date"));
    mUpgradeDateLabel_2 = new LightLabel;
    mUpgradeDateFrame = createFrame(mUpgradeDateLabel_1, mUpgradeDateLabel_2);


    /* 主机名 */
    mHostNameLabel_1 = new FixLabel(tr("HostName"));
    mHostNameLabel_2 = new LightLabel;
    mHostNameLabel_3 = new LightLabel;
    mHostNameLabel_3->setFixedSize(16, 16);
    mHostNameLabel_3->setProperty("useIconHighlightEffect", 0x8);
    mHostNameLabel_3->setPixmap(QIcon::fromTheme("document-edit-symbolic").pixmap(mHostNameLabel_3->size()));
    mHostNameLabel_3->setScaledContents(true);
    mHostNameLabel_2->installEventFilter(this);
    mHostNameLabel_3->installEventFilter(this);
    mHostNameFrame = createFrame(mHostNameLabel_1, mHostNameLabel_2, mHostNameLabel_3);

    /* 内核 */
    mKernelLabel_1 = new FixLabel(tr("Kernel"));
    mKernelLabel_2 = new LightLabel;
    mKernelFrame = createFrame(mKernelLabel_1, mKernelLabel_2);

    /* CPU */
    mCpuLabel_1 = new FixLabel(tr("CPU"));
    mCpuLabel_2 = new LightLabel;
    mCpuFrame = createFrame(mCpuLabel_1, mCpuLabel_2);

    /* 内存 */
    mMemoryLabel_1 = new FixLabel(tr("Memory"));
    mMemoryLabel_2 = new LightLabel;
    mMemoryFrame = createFrame(mMemoryLabel_1, mMemoryLabel_2);

    /* 硬盘 */
    mDiskLabel_1 = new FixLabel(tr("Disk"));
    mDiskLabel_2 = new LightLabel;
    mDiskFrame = createFrame(mDiskLabel_1, mDiskLabel_2);

    /* 桌面 */
    mDesktopLabel_1 = new FixLabel(tr("Desktop"));
    mDesktopLabel_2 = new LightLabel;
    mDesktopFrame = createFrame(mDesktopLabel_1, mDesktopLabel_2);

    /* 用户名 */
    mUsernameLabel_1 = new FixLabel(tr("User"));
    mUsernameLabel_2 = new LightLabel;
    mUsernameFrame = createFrame(mUsernameLabel_1, mUsernameLabel_2);

    /* 激活信息 */
    mActivationFrame = initActiveUi();

    /* 版权所有 */
    mTipLabel = new FixLabel(QString(tr("Copyright © %1 %2. All rights reserved.").arg(mCopyRightYear).arg(mCopyRightName)), Aboutwidget);
    mTipLabel->setContentsMargins(16, 0, 0, 0);

    /* 隐私和协议 */
    mPrivacyFrame = initPrivacyUi();

    /* 授权信息和隐私协议弹窗 */
    mBtnFrame = initInfoBtnUi();

    /* Intel手册 */
    mHoldWidget = initHoldUi();

    item = new QSpacerItem(10 ,32);
    mInformationLayout->addWidget(mLogoLabel);
    mInformationLayout->addSpacing(24);
    mInformationLayout->addWidget(mVersionFrame);
    mInformationLayout->addWidget(mVersionNumberFrame);
    mInformationLayout->addWidget(mPatchVersionFrame);
    mInformationLayout->addWidget(mInstallDateFrame);
    mInformationLayout->addWidget(mUpgradeDateFrame);
    mInformationLayout->addWidget(mHostNameFrame);
    mInformationLayout->addWidget(mKernelFrame);
    mInformationLayout->addWidget(mCpuFrame);
    mInformationLayout->addWidget(mMemoryFrame);
    mInformationLayout->addWidget(mDiskFrame);
    mInformationLayout->addWidget(mDesktopFrame);
    mInformationLayout->addWidget(mUsernameFrame);

    AboutLayout->addWidget(mTitleLabel);
    AboutLayout->addWidget(mInformationFrame);
    AboutLayout->addWidget(mActivationFrame);
    AboutLayout->addWidget(mTipLabel);
    AboutLayout->addSpacerItem(item);
    AboutLayout->addWidget(mPriTitleLabel);
    AboutLayout->addWidget(mPrivacyFrame);
    AboutLayout->addSpacing(0);
    AboutLayout->addWidget(mBtnFrame);
    AboutLayout->addWidget(mHoldTitleLabel);
    AboutLayout->addWidget(mHoldWidget);

    mverticalLayout->addWidget(Aboutwidget);
    mverticalLayout->addStretch();
}

void AboutUi::initCopyRightName()
{
    if (UkccCommon::isOpenkylin()) {
        mCopyRightName = tr("openKylin");
        mCopyRightYear = QString::number(QDate::currentDate().year());
    } else {
        mCopyRightName = tr("KylinSoft");
        mCopyRightYear = "2020";
    }
}

QFrame *AboutUi::createFrame(FixLabel *label_1, LightLabel *label_2, LightLabel *label_3)
{
    QFrame *frame = new QFrame;
    frame->installEventFilter(this);
    setShape(frame, QFrame::NoFrame);

    QHBoxLayout *layout = new QHBoxLayout(frame);
    layout->setContentsMargins(0, 0, 16, 0);

    label_1->setFixedSize(180,30);

    label_2->setTextInteractionFlags(Qt::TextSelectableByMouse);
    label_2->setCursor(Qt::IBeamCursor);
    label_2->setFixedHeight(30);

    layout->addWidget(label_1);
    layout->addSpacing(16);
    if (label_3) {
        layout->addWidget(label_2);
        layout->addWidget(label_3);
        layout->addStretch();
    } else {
        layout->addWidget(label_2, Qt::AlignLeft);
    }

    return frame;
}

void AboutUi::setShape(QFrame *frame, QFrame::Shape shape)
{
    frame->setMinimumSize(QSize(550, shape == QFrame::Box ? 0 : 30));
    frame->setMaximumSize(QSize(16777215, shape == QFrame::Box ? 16777215 : 30));
    frame->setFrameShape(shape);
}

QFrame *AboutUi::initHoldUi()
{
    QFrame *frame = new QFrame;
    frame->setMinimumSize(QSize(550, 120));
    frame->setMaximumSize(QSize(16777215, 120));
    frame->setFrameShape(QFrame::Box);

    QHBoxLayout *mHoldLayout = new QHBoxLayout(frame);
    mHoldLayout->setSpacing(8);
    mHoldLayout->setContentsMargins(16, 0, 8, 0);

    mQrCodeWidget = new QWidget;
    mQrCodeWidget->setFixedSize(104, 104);
    QHBoxLayout *qrhLyt = new QHBoxLayout(mQrCodeWidget);
    qrhLyt->setContentsMargins(0, 4, 0, 0);

    mHpLabel = new QLabel;
    mEducateLabel = new QLabel;
    mEducateIconLabel = new FixLabel;
    mEducateIconLabel->setFixedSize(96,96);

    mHpLabel->setWordWrap(true);
    mEducateLabel->setWordWrap(true);
    mHpLabel->setText(tr("Wechat code scanning obtains HP professional technical support"));
    mEducateLabel->setText(tr("See more about Kylin Tianqi edu platform"));

    mHpBtn = new QPushButton;
    mEducateBtn = new QPushButton;

#ifdef WIN32
    QPluginLoader loader("../HpQRCodePlugin/hp-qrcode-plugind.dll");
#else
    QPluginLoader loader("/usr/lib/x86_64-linux-gnu/hp-qrcode-plugin/libhp-qrcode-plugin.so");

#endif
    QObject *plugin = loader.instance();
    if (plugin) {
        app = qobject_cast<hp::QRCodeInterface*>(plugin);
        mQrCodeWidget->layout()->addWidget(app->createWidget(mQrCodeWidget));
    }
    else{
        qDebug() << "加载插件失败";
    }

    mHpBtn->setText(tr("Learn more HP user manual>>"));
    mHpBtn->setStyleSheet("background: transparent;color:#2FB3E8;font-family:Microsoft YaHei;"
                  "border-width:1px;text-decoration:underline;border-style:none none none;border-color:#2FB3E8;text-align: left");

    mEducateIconLabel->setPixmap(loadSvg(":/help-app.svg", mEducateIconLabel->size().width(), mEducateIconLabel->size().height()));
    mEducateBtn->setText(tr("See user manual>>"));
    mEducateBtn->setStyleSheet("background: transparent;color:#2FB3E8;font-size;font-family:Microsoft YaHei;"
                  "border-width:1px;text-decoration:underline;border-style:none none none;border-color:#2FB3E8;text-align: left");

    QVBoxLayout *hpLayout = new QVBoxLayout();
    hpLayout->setContentsMargins(0, 8, 0, 8);
    hpLayout->setSpacing(4);
    hpLayout->addStretch();
    hpLayout->addWidget(mHpLabel);
    hpLayout->addWidget(mHpBtn);
    hpLayout->addStretch();

    QVBoxLayout *eduLayout = new QVBoxLayout();
    eduLayout->setContentsMargins(0, 8, 0, 8);
    eduLayout->setSpacing(4);
    eduLayout->addStretch();
    eduLayout->addWidget(mEducateLabel);
    eduLayout->addWidget(mEducateBtn);
    eduLayout->addStretch();

    mHoldLayout->addWidget(mQrCodeWidget);
    mHoldLayout->addLayout(hpLayout);
    mHoldLayout->addSpacing(16);
    mHoldLayout->addStretch(1);
    mHoldLayout->addWidget(mEducateIconLabel);
    mHoldLayout->addLayout(eduLayout);
    mHoldLayout->addStretch(1);

    return frame;
}

QFrame *AboutUi::initActiveUi()
{
    QFrame *frame = new QFrame;
    setShape(frame, QFrame::Box);

    QHBoxLayout *mActivationLayout_1 = new QHBoxLayout(frame);
    mActivationLayout_1->setContentsMargins(16, 16, 16, 16);
    mActivationLayout_1->setSpacing(8);

    QGridLayout *mActivationLayout = new QGridLayout();
    mActivationLayout->setVerticalSpacing(8);

    mStatusLabel_1 = new FixLabel;
    mStatusLabel_1->setFixedSize(196, 30);
    mStatusLabel_2 = new LightLabel;
    mSequenceLabel_1 = new FixLabel;
    mSequenceLabel_1->setFixedSize(196, 30);
    mSequenceLabel_2 = new KBorderlessButton;
    mSequenceLabel_2->setObjectName("sequence");
    mSequenceLabel_2->installEventFilter(this);
    mActivationBtn = new QPushButton;
    mActivationBtn->setObjectName("acivation");

    mActivationBtn->setFixedWidth(120);

    mActivationLayout->addWidget(mStatusLabel_1, 0, 0, 1, 1);
    mActivationLayout->addWidget(mStatusLabel_2, 0, 1, 1, 3,Qt::AlignLeft);
    mActivationLayout->addWidget(mSequenceLabel_1, 1, 0, 1, 1);
    mActivationLayout->addWidget(mSequenceLabel_2, 1, 1, 1, 3,Qt::AlignLeft);

    mActivationLayout_1->addLayout(mActivationLayout);
    mActivationLayout_1->addWidget(mActivationBtn);

    return frame;
}

QFrame *AboutUi::initPrivacyUi()
{
    QFrame *frame = new QFrame;
    setShape(frame, QFrame::Box);

    QHBoxLayout *mPrivacyLayout = new QHBoxLayout(frame);
    mPrivacyLayout->setContentsMargins(16, 16, 16, 16);
    mPrivacyLayout->setSpacing(48);
    mPriBtn = new KSwitchButton(frame);
    mPriBtn->setObjectName("privacysettings");

    FixLabel *mPriLabel_1 = new FixLabel(tr("Send optional diagnostic data"));
    LightLabel *mPriLabel_2 = new LightLabel(tr("By sending us diagnostic data, improve the system experience and solve your problems faster"));
    QVBoxLayout *mverticalLayout_2 = new QVBoxLayout;
    mverticalLayout_2->setSpacing(0);
    mverticalLayout_2->setContentsMargins(0, 0, 0, 0);
    mverticalLayout_2->addWidget(mPriLabel_1);
    mverticalLayout_2->addWidget(mPriLabel_2 );

    mPrivacyLayout->addLayout(mverticalLayout_2);
    mPrivacyLayout->addStretch();
    mPrivacyLayout->addWidget(mPriBtn);

    return frame;
}

QFrame *AboutUi::initInfoBtnUi()
{
    QFrame *frame = new QFrame;
    setShape(frame, QFrame::NoFrame);


    QHBoxLayout *mBtnLyt = new QHBoxLayout(frame);
    mBtnLyt->setContentsMargins(16, 0, 0, 0);
    mTrialBtn = new KBorderlessButton(tr("<<Protocol>>"));
    mAndLabel = new FixLabel(tr("and"));
    mAgreeBtn = new KBorderlessButton(tr("<<Privacy>>"));
    mTrialBtn->setStyleSheet("text-decoration:underline");
    mAgreeBtn->setStyleSheet("text-decoration:underline");

    mBtnLyt->addWidget(mTrialBtn);
    mBtnLyt->addWidget(mAndLabel);
    mBtnLyt->addWidget(mAgreeBtn);
    mBtnLyt->addStretch();

    return frame;
}

void AboutUi::initSearchText()
{
    //~ contents_path /About/version
    mVersionLabel_1->setText(tr("Version"));
    //~ contents_path /About/Kernel
    mKernelLabel_1->setText(tr("Kernel"));
    //~ contents_path /About/CPU
    mCpuLabel_1->setText(tr("CPU"));
    //~ contents_path /About/Memory
    mMemoryLabel_1->setText(tr("Memory"));
    //~ contents_path /About/Desktop
    mDesktopLabel_1->setText(tr("Desktop"));
    //~ contents_path /About/User
    mUsernameLabel_1->setText(tr("User"));
    //~ contents_path /About/Status
    mStatusLabel_1->setText(tr("Status"));
    //~ contents_path /About/Active
    mActivationBtn->setText(tr("Active"));
    mSequenceLabel_1->setText(tr("Serial"));
}

void AboutUi::setComponent()
{
    if (!UkccCommon::isTablet()) {
        mDiskFrame->hide();
        mHoldWidget->hide();
        mHoldTitleLabel->hide();
    }  else {
        mPrivacyFrame->hide();
        mHostNameFrame->hide();
        mPriTitleLabel->hide();
        mAndLabel->hide();
        mAgreeBtn->hide();
        mActivationFrame->hide();
        mTipLabel->hide();
        mTrialBtn->hide();
        mPatchVersionFrame->hide();
    }
}

QPixmap AboutUi::loadSvg(const QString &path, int width, int height)
{
    const auto ratio = qApp->devicePixelRatio();
    if (ratio >= 2) {
        width += width;
        height += height;
    } else {
        height *= ratio;
        width *= ratio;
    }
    QPixmap pixmap(width, height);
    QSvgRenderer renderer(path);
    pixmap.fill(Qt::transparent);

    QPainter painter;
    painter.begin(&pixmap);
    renderer.render(&painter);
    painter.end();

    pixmap.setDevicePixelRatio(ratio);
    return pixmap;
}
