/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#ifndef TIMEZONECHOOSER_H
#define TIMEZONECHOOSER_H

#include "timezonemap.h"
#include <QFrame>
#include <QMap>
#include <QWidget>
#include <QLabel>
#include <QPushButton>
#include <QAbstractItemView>
#include <QPropertyAnimation>
#include <QDialog>

#include "ksearchlineedit.h"
using namespace kdk;

class TimeZoneChooser : public QDialog
{
    Q_OBJECT
public:
    explicit TimeZoneChooser(QWidget *parent);
    void setTitle(QString title);
    void hide();

public slots:
    void setMarkedTimeZoneSlot(QString timezone);

Q_SIGNALS:
    void confirmed(QString zone, QString title);
    void cancelled();

protected:
    void keyPressEvent(QKeyEvent *event);
    void keyRealeaseEvent(QKeyEvent* event);
    void closeEvent(QCloseEvent *e);

private:
    QSize getFitSize();
    void initSize();

private:
    ZoneInfo* m_zoneinfo;

    QMap<QString, QString> m_zoneCompletion;
    QAbstractItemView      *m_popup;

    TimezoneMap* m_map;
    KSearchLineEdit* m_searchInput;
    QPushButton *m_cancelBtn;
    QPushButton *m_confirmBtn;
    bool       firstin = true;
};

#endif // TIMEZONECHOOSER_H
